#include "ToRORd_fkatp_endo.h"
#include <stdlib.h>
#include <stdio.h>

real max_step;
real min_step;
real abstol;
real reltol;
bool adpt;
real *ode_dt, *ode_previous_dt, *ode_time_new;

GET_CELL_MODEL_DATA(init_cell_model_data) {

    if(get_initial_v)
        cell_model->initial_v = INITIAL_V;
    if(get_neq)
        cell_model->number_of_ode_equations = NEQ; //for count and m
}

SET_ODE_INITIAL_CONDITIONS_CPU(set_model_initial_conditions_cpu) {

    log_info("Using ToRORd_fkatp_endo CPU model\n");

    uint32_t num_cells = solver->original_num_cells;
	solver->sv = (real*)malloc(NEQ*num_cells*sizeof(real));

    max_step = solver->max_dt;
    min_step = solver->min_dt;
    abstol   = solver->abs_tol;
    reltol   = solver->rel_tol;
    adpt     = solver->adaptive;

    if(adpt) {
        ode_dt = (real*)malloc(num_cells*sizeof(real));

        OMP(parallel for)
        for(int i = 0; i < num_cells; i++) {
            ode_dt[i] = solver->min_dt;
        }

        ode_previous_dt = (real*)calloc(num_cells, sizeof(real));
        ode_time_new    = (real*)calloc(num_cells, sizeof(real));
        log_info("Using Adaptive Euler model to solve the ODEs\n");
    } else {
        log_info("Using Euler model to solve the ODEs\n");
    }

    real *ischFactor;
    real ischFactor_size = num_cells*sizeof(real);

    real *APEXB;
    real APEXB_size = num_cells*sizeof(real);
	
	int *HCMRE;
	real HCMRE_size = num_cells*sizeof(int);
	
	int *CELLT;
	real CELLT_size = num_cells*sizeof(int);

    struct extra_data_for_HCM* extra_data_from_solver = (struct extra_data_for_HCM*)solver->ode_extra_data;
    bool deallocate = false;
	
    if(solver->ode_extra_data) {
		ischFactor = extra_data_from_solver->ISCH;
		HCMRE = extra_data_from_solver->HCMRE;
		CELLT = extra_data_from_solver->CELLT;
		APEXB = extra_data_from_solver->APEXB;
    }
    else { // Default values for healthy cell
        ischFactor = (real*) malloc(ischFactor_size);
	APEXB = (real*) malloc(APEXB_size);
		HCMRE = (int*) malloc(HCMRE_size);
		CELLT = (int*) malloc(CELLT_size);

        for(uint64_t i = 0; i < num_cells; i++) {
			ischFactor[i] = 1.0; // Default to non-ischemic
			HCMRE[i] = 1.0; // Default to non-HCM
			CELLT[i] = 1.0; // Default to endo
			APEXB[i] = 1.0; // Default to no apex base gradient
        }
	


        deallocate = true;
    }

    OMP(parallel for)
    for(uint32_t i = 0; i < num_cells; i++) {

        real *sv = &solver->sv[i * NEQ];
		
		
		//Initial states x8    
		
		if(ischFactor[i] >= 0.5 && HCMRE[i] == 1 && CELLT[i] == 1){
			// ctrl_endo_base
sv[0] = -9.019130e+01f;
sv[1] = 1.101360e-02f;
sv[2] = 1.257420e+01f;
sv[3] = 1.257460e+01f;
sv[4] = 1.501910e+02f;
sv[5] = 1.501910e+02f;
sv[6] = 7.440480e-05f;
sv[7] = 6.483400e-05f;
sv[8] = 1.538950e+00f;
sv[9] = 1.536690e+00f;
sv[10] = 5.922220e-04f;
sv[11] = 8.551840e-01f;
sv[12] = 8.550390e-01f;
sv[13] = 7.152230e-01f;
sv[14] = 8.548180e-01f;
sv[15] = 1.242100e-04f;
sv[16] = 5.708110e-01f;
sv[17] = 3.235060e-01f;
sv[18] = 8.637250e-04f;
sv[19] = 9.996960e-01f;
sv[20] = 6.018780e-01f;
sv[21] = 4.400620e-04f;
sv[22] = 9.996960e-01f;
sv[23] = 6.665500e-01f;
sv[24] = -8.224240e-33f;
sv[25] = 1.000000e+00f;
sv[26] = 9.411300e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.999030e-01f;
sv[29] = 9.999850e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 4.859960e-04f;
sv[33] = 8.272410e-04f;
sv[34] = 6.317220e-04f;
sv[35] = 7.689910e-04f;
sv[36] = 9.983320e-01f;
sv[37] = 2.584730e-04f;
sv[38] = 8.467680e-06f;
sv[39] = 2.418860e-01f;
sv[40] = 1.509360e-04f;
sv[41] = -2.516360e-25f;
sv[42] = 2.247390e-23f;
		}
		else if(ischFactor[i] >= 0.5 && HCMRE[i] == 1 && CELLT[i] == 3){
			// ctrl_epi_base
sv[0] = -9.029560e+01f;
sv[1] = 1.278400e-02f;
sv[2] = 1.303630e+01f;
sv[3] = 1.303660e+01f;
sv[4] = 1.497920e+02f;
sv[5] = 1.497920e+02f;
sv[6] = 6.604150e-05f;
sv[7] = 5.746290e-05f;
sv[8] = 1.815830e+00f;
sv[9] = 1.814040e+00f;
sv[10] = 5.790230e-04f;
sv[11] = 8.569850e-01f;
sv[12] = 8.569230e-01f;
sv[13] = 7.183180e-01f;
sv[14] = 8.567970e-01f;
sv[15] = 1.217730e-04f;
sv[16] = 5.772230e-01f;
sv[17] = 3.345220e-01f;
sv[18] = 8.576710e-04f;
sv[19] = 9.997020e-01f;
sv[20] = 9.997010e-01f;
sv[21] = 4.369760e-04f;
sv[22] = 9.997020e-01f;
sv[23] = 9.997010e-01f;
sv[24] = -3.615430e-34f;
sv[25] = 1.000000e+00f;
sv[26] = 9.491650e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.999340e-01f;
sv[29] = 9.999880e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 3.042030e-04f;
sv[33] = 5.218410e-04f;
sv[34] = 6.235430e-04f;
sv[35] = 7.633390e-04f;
sv[36] = 9.984020e-01f;
sv[37] = 2.046080e-04f;
sv[38] = 6.658310e-06f;
sv[39] = 2.288740e-01f;
sv[40] = 1.491520e-04f;
sv[41] = 1.068350e-25f;
sv[42] = -8.289150e-23f;
		}
		else if(ischFactor[i] >= 0.5 && HCMRE[i] == 2 && CELLT[i] == 1){
			// hcm_endo_base
sv[0] = -8.783100e+01f;
sv[1] = 1.542690e-02f;
sv[2] = 1.479190e+01f;
sv[3] = 1.479220e+01f;
sv[4] = 1.470430e+02f;
sv[5] = 1.470430e+02f;
sv[6] = 8.061560e-05f;
sv[7] = 6.924220e-05f;
sv[8] = 1.567370e+00f;
sv[9] = 1.556660e+00f;
sv[10] = 9.845420e-04f;
sv[11] = 8.088900e-01f;
sv[12] = 8.064120e-01f;
sv[13] = 6.391190e-01f;
sv[14] = 8.001300e-01f;
sv[15] = 1.944740e-04f;
sv[16] = 4.544730e-01f;
sv[17] = 2.004510e-01f;
sv[18] = 1.012750e-03f;
sv[19] = 9.995400e-01f;
sv[20] = 4.582920e-01f;
sv[21] = 5.160270e-04f;
sv[22] = 9.995400e-01f;
sv[23] = 4.984880e-01f;
sv[24] = 4.542130e-27f;
sv[25] = 1.000000e+00f;
sv[26] = 8.689670e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.975330e-01f;
sv[29] = 9.996230e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 6.278020e-04f;
sv[33] = 1.128000e-03f;
sv[34] = 1.023750e-03f;
sv[35] = 9.061610e-04f;
sv[36] = 9.930950e-01f;
sv[37] = 4.795810e-03f;
sv[38] = 1.788070e-04f;
sv[39] = 3.511380e-01f;
sv[40] = 1.972570e-04f;
sv[41] = -2.275050e-23f;
sv[42] = -1.028870e-22f;
		}
		else if(ischFactor[i] >= 0.5 && HCMRE[i] == 2 && CELLT[i] == 3){
			// hcm_epi_base
sv[0] = -8.823050e+01f;
sv[1] = 1.921580e-02f;
sv[2] = 1.500350e+01f;
sv[3] = 1.500380e+01f;
sv[4] = 1.468670e+02f;
sv[5] = 1.468670e+02f;
sv[6] = 7.225230e-05f;
sv[7] = 6.192300e-05f;
sv[8] = 1.963710e+00f;
sv[9] = 1.955610e+00f;
sv[10] = 9.036270e-04f;
sv[11] = 8.175330e-01f;
sv[12] = 8.161670e-01f;
sv[13] = 6.528390e-01f;
sv[14] = 8.129730e-01f;
sv[15] = 1.802640e-04f;
sv[16] = 4.807040e-01f;
sv[17] = 2.254980e-01f;
sv[18] = 9.858230e-04f;
sv[19] = 9.995720e-01f;
sv[20] = 9.993160e-01f;
sv[21] = 5.023000e-04f;
sv[22] = 9.995720e-01f;
sv[23] = 9.994920e-01f;
sv[24] = -6.466790e-29f;
sv[25] = 1.000000e+00f;
sv[26] = 8.800790e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.982260e-01f;
sv[29] = 9.997860e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 4.072150e-04f;
sv[33] = 7.396290e-04f;
sv[34] = 8.606430e-04f;
sv[35] = 8.824960e-04f;
sv[36] = 9.957130e-01f;
sv[37] = 2.454530e-03f;
sv[38] = 8.957320e-05f;
sv[39] = 3.436090e-01f;
sv[40] = 1.883590e-04f;
sv[41] = -1.668620e-23f;
sv[42] = 1.556170e-22f;
		}
		else if(ischFactor[i] < 0.5 && HCMRE[i] == 1 && CELLT[i] == 1){
			// ctrl_endo_isch
sv[0] = -8.162070e+01f;
sv[1] = 7.947950e-03f;
sv[2] = 1.219750e+01f;
sv[3] = 1.219780e+01f;
sv[4] = 1.509170e+02f;
sv[5] = 1.509170e+02f;
sv[6] = 6.760420e-05f;
sv[7] = 5.920890e-05f;
sv[8] = 1.350490e+00f;
sv[9] = 1.347830e+00f;
sv[10] = 3.664800e-03f;
sv[11] = 6.320060e-01f;
sv[12] = 6.308710e-01f;
sv[13] = 4.014580e-01f;
sv[14] = 6.260100e-01f;
sv[15] = 6.324700e-04f;
sv[16] = 3.048310e-01f;
sv[17] = 1.464500e-01f;
sv[18] = 1.539010e-03f;
sv[19] = 9.986380e-01f;
sv[20] = 5.893730e-01f;
sv[21] = 7.843760e-04f;
sv[22] = 9.986390e-01f;
sv[23] = 6.424060e-01f;
sv[24] = -3.475840e-31f;
sv[25] = 1.000000e+00f;
sv[26] = 9.608430e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.999620e-01f;
sv[29] = 9.999940e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 3.418030e-04f;
sv[33] = 5.714080e-04f;
sv[34] = 1.190870e-03f;
sv[35] = 1.412890e-03f;
sv[36] = 9.959180e-01f;
sv[37] = 1.405670e-03f;
sv[38] = 7.260510e-05f;
sv[39] = 1.870410e-01f;
sv[40] = 3.939230e-04f;
sv[41] = -3.751030e-21f;
sv[42] = 9.928200e-20f;
		}
		else if(ischFactor[i] < 0.5 && HCMRE[i] == 1 && CELLT[i] == 3){
			// ctrl_epi_isch
sv[0] = -8.166680e+01f;
sv[1] = 9.907430e-03f;
sv[2] = 1.273800e+01f;
sv[3] = 1.273830e+01f;
sv[4] = 1.504430e+02f;
sv[5] = 1.504430e+02f;
sv[6] = 5.966630e-05f;
sv[7] = 5.217830e-05f;
sv[8] = 1.588290e+00f;
sv[9] = 1.585640e+00f;
sv[10] = 3.629800e-03f;
sv[11] = 6.336340e-01f;
sv[12] = 6.328030e-01f;
sv[13] = 4.033090e-01f;
sv[14] = 6.284410e-01f;
sv[15] = 6.269570e-04f;
sv[16] = 3.067910e-01f;
sv[17] = 1.484150e-01f;
sv[18] = 1.534240e-03f;
sv[19] = 9.986500e-01f;
sv[20] = 9.968800e-01f;
sv[21] = 7.819390e-04f;
sv[22] = 9.986500e-01f;
sv[23] = 9.977160e-01f;
sv[24] = 4.563630e-35f;
sv[25] = 1.000000e+00f;
sv[26] = 9.645410e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.999690e-01f;
sv[29] = 9.999940e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 2.089780e-04f;
sv[33] = 3.520890e-04f;
sv[34] = 1.182180e-03f;
sv[35] = 1.408410e-03f;
sv[36] = 9.960460e-01f;
sv[37] = 1.296530e-03f;
sv[38] = 6.678950e-05f;
sv[39] = 1.843380e-01f;
sv[40] = 3.918230e-04f;
sv[41] = -3.979900e-23f;
sv[42] = 5.014080e-21f;
		}
		else if(ischFactor[i] < 0.5 && HCMRE[i] == 2 && CELLT[i] == 1){
			// hcm_endo_isch
sv[0] = -7.993320e+01f;
sv[1] = 9.765210e-03f;
sv[2] = 1.463860e+01f;
sv[3] = 1.463900e+01f;
sv[4] = 1.475670e+02f;
sv[5] = 1.475670e+02f;
sv[6] = 7.326870e-05f;
sv[7] = 6.302120e-05f;
sv[8] = 1.358490e+00f;
sv[9] = 1.349200e+00f;
sv[10] = 5.195490e-03f;
sv[11] = 5.703810e-01f;
sv[12] = 5.601510e-01f;
sv[13] = 3.353900e-01f;
sv[14] = 5.399510e-01f;
sv[15] = 8.712730e-04f;
sv[16] = 2.507700e-01f;
sv[17] = 1.068620e-01f;
sv[18] = 1.724360e-03f;
sv[19] = 9.981700e-01f;
sv[20] = 5.165630e-01f;
sv[21] = 8.789180e-04f;
sv[22] = 9.981700e-01f;
sv[23] = 5.453320e-01f;
sv[24] = 1.686370e-29f;
sv[25] = 1.000000e+00f;
sv[26] = 9.256800e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.994900e-01f;
sv[29] = 9.999590e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 4.358870e-04f;
sv[33] = 7.805080e-04f;
sv[34] = 1.501550e-03f;
sv[35] = 1.586970e-03f;
sv[36] = 9.912360e-01f;
sv[37] = 5.371170e-03f;
sv[38] = 3.039120e-04f;
sv[39] = 2.639080e-01f;
sv[40] = 4.769970e-04f;
sv[41] = 2.037800e-25f;
sv[42] = 6.727880e-23f;
		}
		else if(ischFactor[i] < 0.5 && HCMRE[i] == 2 && CELLT[i] == 3){
			// hcm_epi_isch
sv[0] = -8.014940e+01f;
sv[1] = 1.239970e-02f;
sv[2] = 1.494100e+01f;
sv[3] = 1.494140e+01f;
sv[4] = 1.473030e+02f;
sv[5] = 1.473030e+02f;
sv[6] = 6.547250e-05f;
sv[7] = 5.622780e-05f;
sv[8] = 1.653350e+00f;
sv[9] = 1.644590e+00f;
sv[10] = 4.969550e-03f;
sv[11] = 5.786020e-01f;
sv[12] = 5.706810e-01f;
sv[13] = 3.437670e-01f;
sv[14] = 5.532500e-01f;
sv[15] = 8.362510e-04f;
sv[16] = 2.578860e-01f;
sv[17] = 1.117990e-01f;
sv[18] = 1.699410e-03f;
sv[19] = 9.982390e-01f;
sv[20] = 9.831070e-01f;
sv[21] = 8.661930e-04f;
sv[22] = 9.982390e-01f;
sv[23] = 9.872330e-01f;
sv[24] = -6.452580e-31f;
sv[25] = 1.000000e+00f;
sv[26] = 9.264900e-01f;
sv[27] = 1.000000e+00f;
sv[28] = 9.995470e-01f;
sv[29] = 9.999660e-01f;
sv[30] = 1.000000e+00f;
sv[31] = 1.000000e+00f;
sv[32] = 2.798990e-04f;
sv[33] = 5.053180e-04f;
sv[34] = 1.444880e-03f;
sv[35] = 1.564110e-03f;
sv[36] = 9.922710e-01f;
sv[37] = 4.470110e-03f;
sv[38] = 2.500140e-04f;
sv[39] = 2.631860e-01f;
sv[40] = 4.652300e-04f;
sv[41] = -5.854610e-24f;
sv[42] = 2.684190e-22f;
		}
    }
	

    if(deallocate) free(ischFactor);
	if(deallocate) free(HCMRE);
	if(deallocate) free(CELLT);
}

SOLVE_MODEL_ODES(solve_model_odes_cpu) {

    uint32_t sv_id;

	real *APEXB;
    real *ischFactor;
	int *HCMRE;
	int *CELLT;

    size_t num_cells_to_solve = ode_solver->num_cells_to_solve;
    uint32_t * cells_to_solve = ode_solver->cells_to_solve;
    real *sv = ode_solver->sv;
    real dt = ode_solver->min_dt;
    uint32_t num_steps = ode_solver->num_steps;

    int num_extra_parameters = 4;
    real extra_par[num_extra_parameters];
	
    real ischFactor_size = num_cells_to_solve*sizeof(real);
	real HCMRE_size = num_cells_to_solve*sizeof(int);
	real CELLT_size = num_cells_to_solve*sizeof(int);
	real APEXB_size = num_cells_to_solve*sizeof(real);

    struct extra_data_for_HCM* extra_data_from_solver = (struct extra_data_for_HCM*)ode_solver->ode_extra_data;
    bool deallocate = false;
	
    if(ode_solver->ode_extra_data) {
        ischFactor = extra_data_from_solver->ISCH;
		HCMRE = extra_data_from_solver->HCMRE;
		CELLT = extra_data_from_solver->CELLT;
	APEXB = extra_data_from_solver->APEXB;
        extra_par[0] = extra_data_from_solver->INaFactor;
        extra_par[1] = extra_data_from_solver->ICaLFactor;
        extra_par[2] = extra_data_from_solver->Ko;
        extra_par[3] = extra_data_from_solver->f;

    }
    else {
        // Default values for a healthy cell ///////////
		extra_par[0] = 1.0f;
        extra_par[1] = 1.0f;
        extra_par[2] = 5.0f;
        extra_par[3] = 0.0f;
		
		ischFactor = (real*) malloc(ischFactor_size);
		HCMRE = (int*) malloc(HCMRE_size);
		CELLT = (int*) malloc(CELLT_size);
		APEXB = (real*) malloc(APEXB_size);

        for(uint64_t i = 0; i < num_cells_to_solve; i++) {
			ischFactor[i] = 1.0; // Default to non-ischemic
			HCMRE[i] = 1.0; // Default to non-HCM
			CELLT[i] = 1.0; // Default to endo
			APEXB[i] = 1.0;
        }
        deallocate = true;
    }

    #pragma omp parallel for private(sv_id)
    for (u_int32_t i = 0; i < num_cells_to_solve; i++) {
			if(cells_to_solve)
				sv_id = cells_to_solve[i];
			else
				sv_id = i;

			if(adpt) {

				solve_forward_euler_cpu_adpt(sv + (sv_id * NEQ), stim_currents[i], current_t + dt, sv_id, ischFactor[i], extra_par, HCMRE[i], CELLT[i], APEXB[i]);
			}
			else {
				for (int j = 0; j < num_steps; ++j) {
					solve_model_ode_cpu(dt, sv + (sv_id * NEQ), stim_currents[i], ischFactor[i], extra_par, HCMRE[i], CELLT[i], APEXB[i]);
				}

			}
		}
    
    if(deallocate) free(ischFactor);
	if(deallocate) free(HCMRE);
	if(deallocate) free(CELLT);
}

void solve_model_ode_cpu(real dt, real *sv, real stim_current, real ischFactor, real *extra_parameters, int HCMRE, int CELLT, real APEXB)  {

    real rY[NEQ], rDY[NEQ];

    for(int i = 0; i < NEQ; i++)
        rY[i] = sv[i];

    RHS_cpu(rY, rDY, stim_current, dt, ischFactor, extra_parameters, HCMRE, CELLT, APEXB);

    for(int i = 0; i < NEQ; i++)
        sv[i] = dt*rDY[i] + rY[i];
}

void solve_forward_euler_cpu_adpt(real *sv, real stim_curr, real final_time, int sv_id, real ischFactor, real *extra_parameters, int HCMRE, int CELLT, real APEXB) {

    const real _beta_safety_ = 0.8;
    int numEDO = NEQ;
    real rDY[numEDO];
    real _tolerances_[numEDO];
    real _aux_tol = 0.0;
    ode_previous_dt[sv_id] = ode_dt[sv_id];
    real edos_old_aux_[numEDO];
    real edos_new_euler_[numEDO];
    real *_k1__ = (real*) malloc(sizeof(real)*numEDO);
    real *_k2__ = (real*) malloc(sizeof(real)*numEDO);
    real *_k_aux__;
    real *dt = &ode_dt[sv_id];
    real *time_new = &ode_time_new[sv_id];
    real *previous_dt = &ode_previous_dt[sv_id];
    if(*time_new + *dt > final_time) {
       *dt = final_time - *time_new;
    }

    RHS_cpu(sv, rDY, stim_curr, *dt, ischFactor, extra_parameters, HCMRE, CELLT, APEXB);
    *time_new += *dt;

    for(int i = 0; i < numEDO; i++){
        _k1__[i] = rDY[i];
    }

    const double __tiny_ = pow(abstol, 2.0);
    int count = 0;
    int count_limit = (final_time - *time_new)/min_step;
    int aux_count_limit = count_limit+2000000;
    if(aux_count_limit > 0) {
        count_limit = aux_count_limit;
    }

    while(1) {
        for(int i = 0; i < numEDO; i++) {
            edos_old_aux_[i] = sv[i];
            edos_new_euler_[i] = _k1__[i] * *dt + edos_old_aux_[i];
            sv[i] = edos_new_euler_[i];
        }

        *time_new += *dt;
        RHS_cpu(sv, rDY, stim_curr, *dt, ischFactor, extra_parameters, HCMRE, CELLT, APEXB);
        *time_new -= *dt;

        double greatestError = 0.0, auxError = 0.0;
        for(int i = 0; i < numEDO; i++) {
            _k2__[i] = rDY[i];
            _aux_tol = fabs(edos_new_euler_[i])*reltol;
            _tolerances_[i] = (abstol > _aux_tol )?abstol:_aux_tol;
            auxError = fabs(( (*dt/2.0)*(_k1__[i] - _k2__[i])) / _tolerances_[i]);

            greatestError = (auxError > greatestError) ? auxError : greatestError;
        }
        ///adapt the time step
        greatestError += __tiny_;
        *previous_dt = *dt;
        ///adapt the time step
        *dt = _beta_safety_ * (*dt) * sqrt(1.0f/greatestError);

        if (*time_new + *dt > final_time) {
            *dt = final_time - *time_new;
        }

        //it doesn't accept the solution
        if ( count < count_limit  && (greatestError >= 1.0f)) {
            //restore the old values to do it again
            for(int i = 0;  i < numEDO; i++) {
                sv[i] = edos_old_aux_[i];
            }

            count++;
            //throw the results away and compute again
        } else{//it accepts the solutions


            if(greatestError >=1.0) {
                printf("Accepting solution with error > %lf \n", greatestError);
            }

            //printf("%e %e\n", _ode->time_new, edos_new_euler_[0]);
            if (*dt < min_step) {
                *dt = min_step;
            }

            else if (*dt > max_step && max_step != 0) {
                *dt = max_step;
            }

            if (*time_new + *dt > final_time) {
                *dt = final_time - *time_new;
            }

            _k_aux__ = _k2__;
            _k2__	= _k1__;
            _k1__	= _k_aux__;

            //it steps the method ahead, with euler solution
            for(int i = 0; i < numEDO; i++){
                sv[i] = edos_new_euler_[i];
            }

            if(*time_new + *previous_dt >= final_time){
                if((fabs(final_time - *time_new) < 1.0e-5) ){
                    break;
                }else if(*time_new < final_time){
                    *dt = *previous_dt = final_time - *time_new;
                    *time_new += *previous_dt;
                    break;

                }else{
                    printf("Error: time_new %.20lf final_time %.20lf diff %e \n", *time_new , final_time, fabs(final_time - *time_new) );
                    break;
                }
            }else{
                *time_new += *previous_dt;
            }

        }
    }

    free(_k1__);
    free(_k2__);
}

void RHS_cpu(const real *sv, real *rDY_, real stim_current, real dt, real ischFactor, real *extra_parameters, int HCMRE, int CELLT, real APEXB) {

    //State variables
    const real v_old_ = sv[0];
    const real CaMKt_old_ = sv[1];
    const real nai_old_ = sv[2];
    const real nass_old_ = sv[3];
    const real ki_old_ = sv[4];
    const real kss_old_ = sv[5];
    const real cai_old_ = sv[6];
    const real cass_old_ = sv[7];
    const real cansr_old_ = sv[8];
    const real cajsr_old_ = sv[9];
    const real m_old_ = sv[10];
    const real h_old_ = sv[11];
    const real j_old_ = sv[12];
    const real hp_old_ = sv[13];
    const real jp_old_ = sv[14];
    const real mL_old_ = sv[15];
    const real hL_old_ = sv[16];
    const real hLp_old_ = sv[17];
    const real a_old_ = sv[18];
    const real iF_old_ = sv[19];
    const real iS_old_ = sv[20];
    const real ap_old_ = sv[21];
    const real iFp_old_ = sv[22];
    const real iSp_old_ = sv[23];
    const real d_old_ = sv[24];
    const real ff_old_ = sv[25];
    const real fs_old_ = sv[26];
    const real fcaf_old_ = sv[27];
    const real fcas_old_ = sv[28];
    const real jca_old_ = sv[29];
    const real ffp_old_ = sv[30];
    const real fcafp_old_ = sv[31];
    const real nca_ss_old_ = sv[32];
    const real nca_i_old_ = sv[33];
    const real C3_old_ = sv[34];
    const real C2_old_ = sv[35];
    const real C1_old_ = sv[36];
    const real O_old_ = sv[37];
    const real I_old_ = sv[38];
    const real xs1_old_ = sv[39];
    const real xs2_old_ = sv[40];
    const real Jrel_np_old_ = sv[41];
    const real Jrel_p_old_ = sv[42];
	
	//printf("mapping %lf ", mapping);

    #include "ToROrd_common.inc.c"
}
